#include "CGen2TagEngineeringDialog.h"

#include <QCloseEvent>

#include <License.h>
#include <permission/Permissions.h>

#include <QrfeTagManipulatorInterface>
#include <reader/QrfeRfePurReader>
#include <tag/QrfeGen2Tag>

#include "CGen2TagEngineeringDialog/CGen2TagMinimumPowerMeasurement.h"
#include "CGen2TagEngineeringDialog/CGen2TagPowerReadMeasurement.h"
#include "CGen2TagEngineeringDialog/CGen2TagReadPerformanceTest.h"


CGen2TagEngineeringDialog::CGen2TagEngineeringDialog(QWidget *parent)
    : QDialog(parent)
	, ConfigDialog()
{
	ui.setupUi(this); 
	m_infoEdit = ui.infoEdit;

	connect(ui.okButton, 					SIGNAL(clicked()),
			this, 							  SLOT(accept()));

	connect(ui.tabWidget, 					SIGNAL(currentChanged(int)),
			this, 							  SLOT(currentTabChanged(int)));

	connect(Permissions::d,					SIGNAL(permissionsChanged()),
			this, 							  SLOT(permissionsChanged()));

    //ui.licenseFrame->setVisible(!License::d->hasLicense(QrfeLicense::ReaderSuite_EngineeringLicense));
    ui.licenseFrame->setVisible(false);

	m_loaded = false;
}


CGen2TagEngineeringDialog::~CGen2TagEngineeringDialog()
{
	while(m_tabWidgets.size() > 0)
	{
		TagTabWidget* widget = m_tabWidgets.takeLast();
		delete widget;
	}
}


int CGen2TagEngineeringDialog::execPrivate ( )
{
	ui.tagIdEdit->setText(m_tag->tagId());
	ui.readerIdEdit->setText(m_reader->name());

	uchar maxFreq;
	m_reader->getCurrentAttenuation(m_originalAttenuation);
	m_reader->getFrequency(m_originalFrequencyMode, maxFreq, m_originalFrequency);

	if(m_antennaId != 0)
	{
		m_reader->getAntennaSequence(m_originalSequence);

		m_reader->setWorkingAntenna(m_antennaId);
		QPair<uchar,ulong> sequ;
		sequ.first 	= m_antennaId;
		sequ.second = 0;
		m_reader->setAntennaSequence(QList<QPair<uchar,ulong> > () << sequ);
	}


	for(int i = 0; i < m_tabWidgets.size(); i++)
	{
		TagTabWidget* widget =  m_tabWidgets.at(i);
		if(!widget->init(m_reader, m_tag))
			ui.tabWidget->setTabEnabled(i, false);
		else
			ui.tabWidget->setTabEnabled(i, true);
	}

	return QDialog::exec();
}

int CGen2TagEngineeringDialog::exec(QrfeReaderInterface* ph, QString tagId, uint antennaId)
{
	m_reader = ph;
	m_antennaId = antennaId;

	if(m_reader->tagType() != QrfeGlobal::TAG_GEN2)
		return 0;

	QrfeTagManipulatorInterface* 	tagManipulator;
	if((tagManipulator = m_reader->getTagManipulator()) == 0 || dynamic_cast<QrfeGen2ManipulatorInterface*>(tagManipulator) == 0)
		return 0;

	m_tag = new QrfeGen2Tag(tagId, dynamic_cast<QrfeGen2ManipulatorInterface*>(tagManipulator), this);

	return execPrivate();
}


void CGen2TagEngineeringDialog::done(int r)
{
	foreach(TagTabWidget* widget, m_tabWidgets)
	{
		widget->deinit();
	}

	m_reader->setAttenuation(m_originalAttenuation);
	m_reader->setFrequency(m_originalFrequencyMode, m_originalFrequency);
	m_reader->setAntennaSequence(m_originalSequence);

	delete m_tag;
	QDialog::done(r);
}


void CGen2TagEngineeringDialog::tabWidgetWorking()
{
	TagTabWidget* w = qobject_cast<TagTabWidget*>(sender());
	if(w == 0)
		return;

	for(int i = 0; i < m_tabWidgets.size(); i++)
	{
		TagTabWidget* widget =  m_tabWidgets.at(i);
		if(widget == w)
			ui.tabWidget->setTabEnabled(i, true);
		else
			ui.tabWidget->setTabEnabled(i, false);
	}
	ui.okButton->setEnabled(false);
}

void CGen2TagEngineeringDialog::tabWidgetIdle()
{
	for(int i = 0; i < m_tabWidgets.size(); i++)
	{
		ui.tabWidget->setTabEnabled(i, true);
	}
	ui.okButton->setEnabled(true);
	reloadExecutionCount(ui.tabWidget->currentIndex());
}

void CGen2TagEngineeringDialog::closeEvent ( QCloseEvent * event )
{
	bool working = false;
	foreach(TagTabWidget* widget, m_tabWidgets)
	{
		if(widget->isWorking())
		{
			working = true;
			break;
		}
	}

	if(working){
		event->ignore();
		return;
	}

	QDialog::closeEvent(event);
}

void CGen2TagEngineeringDialog::currentTabChanged( int index )
{
	foreach(TagTabWidget* widget, m_tabWidgets)
	{
		widget->clearView();
	}
	reloadExecutionCount(index);
}


void CGen2TagEngineeringDialog::addTabWidget(TagTabWidget* widget)
{
	m_tabWidgets << widget;
	ui.tabWidget->addTab(widget, widget->name());
	connect(widget, 	SIGNAL(working()),
			this, 		  SLOT(tabWidgetWorking()));
	connect(widget, 	SIGNAL(idle()),
			this, 		  SLOT(tabWidgetIdle()));
}

void CGen2TagEngineeringDialog::reloadExecutionCount(int tabIndex)
{
	if(tabIndex >= m_tabWidgets.size() || tabIndex < 0)
		return;

	TabWidget* tab = m_tabWidgets.at(tabIndex);
	if(tab->hasExecutionCount())
	{
		ui.licenseFrame->setVisible(true);
		ui.executionCountLabel->setText(QString::number(tab->executionCount()));
	}
	else
		ui.licenseFrame->setVisible(false);
}


void CGen2TagEngineeringDialog::permissionsChanged()
{
	if(Permissions::d->tagEngineering() && !m_loaded)
	{
		addTabWidget(new CGen2TagMinimumPowerMeasurement(ui.infoEdit, this));
		addTabWidget(new CGen2TagPowerReadMeasurement(ui.infoEdit, this));
		addTabWidget(new CGen2TagReadPerformanceTest(ui.infoEdit, this));
		m_loaded = true;
	}
}
